/*
 * Decompiled with CFR 0.152.
 */
package com.roguewave.chart.standard.v2_1.parts;

import com.roguewave.chart.core.v2_1.graphics.Canvas3D;
import com.roguewave.chart.core.v2_1.graphics.Drawable;
import com.roguewave.chart.core.v2_1.graphics.RelativePosition;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.io.Serializable;

class SingleRowLegendDrawable
implements Drawable,
Serializable {
    String[] legendItems_;
    Color[] colors_;
    RelativePosition position_;
    Font legendFont_;
    int boxSize_;
    Color textColor_;
    Color backgroundColor_;

    public SingleRowLegendDrawable(String[] legendItems, Color[] colors, RelativePosition position, Font legendFont, int boxSize, Color textColor, Color backgroundColor) {
        this.legendItems_ = legendItems;
        this.colors_ = colors;
        this.position_ = position;
        this.legendFont_ = legendFont;
        this.boxSize_ = boxSize;
        this.textColor_ = textColor;
        this.backgroundColor_ = backgroundColor;
    }

    public void drawOn(Canvas3D canvas, Graphics g) {
        Dimension size = canvas.getSize();
        g.setFont(this.legendFont_);
        FontMetrics metrics = g.getFontMetrics();
        int fontHeight = metrics.getHeight();
        int totalTextWidth = 0;
        for (int i = 0; i < this.legendItems_.length; ++i) {
            totalTextWidth += metrics.stringWidth(this.legendItems_[i]);
        }
        int lwidth = totalTextWidth + (this.boxSize_ + 6) * this.legendItems_.length;
        int totalWidth = lwidth + 10;
        int totalHeight = (this.boxSize_ > fontHeight ? this.boxSize_ : fontHeight) + 9;
        int x = this.position_.left(size.width, totalWidth);
        int y = this.position_.top(size.height, totalHeight);
        g.setColor(this.backgroundColor_);
        g.fillRect(x, y, totalWidth, totalHeight);
        int labelY = y + (int)((double)(totalHeight + fontHeight) / 2.0 + 0.5) - metrics.getMaxDescent();
        int bx = x + 5;
        int by = y + (int)((double)(totalHeight - this.boxSize_) / 2.0);
        for (int i = 0; i < this.legendItems_.length; ++i) {
            g.setColor(this.backgroundColor_);
            g.draw3DRect(bx, by, this.boxSize_, this.boxSize_, true);
            g.draw3DRect(bx + 1, by + 1, this.boxSize_ - 2, this.boxSize_ - 2, true);
            g.setColor(this.colors_[i]);
            g.drawRect(bx + 2, by + 2, this.boxSize_ - 4, this.boxSize_ - 4);
            g.fillRect(bx + 2, by + 2, this.boxSize_ - 4, this.boxSize_ - 4);
            g.setColor(this.textColor_);
            g.drawString(this.legendItems_[i], bx + this.boxSize_ + 2, labelY);
            bx += metrics.stringWidth(this.legendItems_[i]) + this.boxSize_ + 6;
        }
        g.setColor(this.backgroundColor_);
        g.draw3DRect(x, y, totalWidth, totalHeight, false);
        g.draw3DRect(x + 1, y + 1, totalWidth - 2, totalHeight - 2, false);
    }
}

